/*
 * AS399X_Defines.cpp
 *
 *  Created on: 15.04.2010
 *      Author: stefan.detter
 */

#include "../../inc/as399x/AS399X_Defines.h"

/*----------------------------------------------------------------- Registers ------------------------------------------------*/

//Main Control
/*! @brief AS3990 register: status control */
#define AS399X_ADDR_STATUSCTRL                0x00
/*! @brief AS3990 register: protocol control */
#define AS399X_ADDR_PROTOCOLCTRL              0x01


//Protocol
/*! @brief AS3990 register: transmit options GEN2 */
#define AS399X_ADDR_TXOPTGEN2                 0x02
/*! @brief AS3990 register: receive options GEN2 */
#define AS399X_ADDR_RXOPTGEN2                 0x03
/*! @brief AS3990 register: TRcal low */
#define AS399X_ADDR_TRCALREGGEN2              0x04
/*! @brief AS3990 register: TRcal and misc */
#define AS399X_ADDR_TRCALREGGEN2MISC          0x05
/*! @brief AS3990 register: transmition reply wait time */
#define AS399X_ADDR_TXREPLYINSLOT             0x06
/*! @brief AS3990 register: wait time until no response interrupt is generated */
#define AS399X_ADDR_RXNORESPWAIT              0x07
/*! @brief AS3990 register: wait time after transmition until the receiver is enabled */
#define AS399X_ADDR_RXWAITTIME                0x08
/*! @brief AS3990 register: receive special settings */
#define AS399X_ADDR_RXSPECIAL                 0x09
/*! @brief AS3990 register: receive special settings 2 */
#define AS399X_ADDR_RXSPECIAL2                0x0A
/*! @brief AS3990 register: regulator and IO control */
#define AS399X_ADDR_REGIOCONTROL              0x0B
/*! @brief AS3990 register: measurement selector */
#define AS399X_ADDR_MEASURE_SELECTOR          0x11
/*! @brief AS3990 register: chip version */
#define AS399X_ADDR_TESTSETTING				  0x12
/*! @brief AS3990 register: chip version */
#define AS399X_ADDR_VERSIONREG                0x13
/*! @brief AS3990 register: CL_sys,analouge out and CP control */
#define AS399X_ADDR_CLSYSAOCPCTRL             0x14
/*! @brief AS3990 register: modulator control */
#define AS399X_ADDR_MODULATORCTRL             0x15
/*! @brief AS3990 register: PLL R, A/B divider main register (three bytes deep) */
#define AS399X_ADDR_PLLMAIN                   0x16
/*! @brief AS3990 register: PLL A/B divider auxiliary register (three bytes deep) */
#define AS399X_ADDR_PLLAUX                    0x17
/*! @brief AS3990 register: DAC control */
#define AS399X_ADDR_DAC                       0x18
/*! @brief AS3990 register: ADC control */
#define AS399X_ADDR_ADC                       0x19


//Status
/*! @brief AS3990 register: IRQ status */
#define AS399X_ADDR_IRQSTATUS                 0x0C
/*! @brief AS3990 register: IRQ mask */
#define AS399X_ADDR_IRQMASKREG                0x0D
/*! @brief AS3990 register: AGC and Internal status */
#define AS399X_ADDR_AGCINTERNALSTATUS         0x0E
/*! @brief AS3990 register: RSSI levels */
#define AS399X_ADDR_RSSILEVELS                0x0F
/*! @brief AS3990 register: AGL status */
#define AS399X_ADDR_AGLSTATUS                 0x10


//Testregisters
/*! @brief AS3990 register: Test setting 1 and measurement selection */
#define AS399X_ADDR_TESTSET1                  0x11
/*! @brief AS3990 register: Test setting 2 */
#define AS399X_ADDR_TESTSET2                  0x12


//FIFO registers
/*! @brief AS3990 register: number of bytes to receive (upper byte) */
#define AS399X_ADDR_RXLENGTHUP                0x1A
/*! @brief AS3990 register: number of bytes to receive (lower byte) */
#define AS399X_ADDR_RXLENGTHLOW               0x1B
/*! @brief AS3990 register: FIFO status */
#define AS399X_ADDR_FIFOSTATUS                0x1C
/*! @brief AS3990 register: number of bytes to transmit (upper byte) */
#define AS399X_ADDR_TXLENGTHUP                0x1D
/*! @brief AS3990 register: number of bytes to transmit (lower byte) */
#define AS399X_ADDR_TXLENGTHLOW               0x1E
/*! @brief AS3990 register: data FIFO */
#define AS399X_ADDR_FIFO                      0x1F



AS399X_Defines::AS399X_Defines()
{
}

AS399X_Defines::~AS399X_Defines()
{
}


QString AS399X_Defines::regAddrToString ( uchar addr )
{
	switch(addr)
	{
	case 0x00: return QString("Chip status control");
	case 0x01: return QString("Protocol control");
	case 0x02: return QString("TX options Gen2");
	case 0x03: return QString("RX options Gen2");
	case 0x04: return QString("TRcal L register Gen2");
	case 0x05: return QString("TRcal H and misc");
	case 0x06: return QString("TX replay in slot");
	case 0x07: return QString("RX no response wait");
	case 0x08: return QString("RX wait time");
	case 0x09: return QString("RX special setting");
	case 0x0A: return QString("RX special setting2");
	case 0x0B: return QString("Regulator and IO control");
	case 0x0C: return QString("IRQ and status");
	case 0x0D: return QString("Interrupt mask register");
	case 0x0E: return QString("AGC and internal status register");
	case 0x0F: return QString("RSSI levels");
	case 0x10: return QString("AGL status register");

	case 0x11: return QString("Measurement selection");
	case 0x12: return QString("Test setting");

	case 0x13: return QString("Version register");

	case 0x14: return QString("CL_SYS, analog out, and CP");
	case 0x15: return QString("Modulator control (3 bytes deep)");
	case 0x16: return QString("PLL main (3 bytes deep)");

	case 0x17: return QString("PLL auxiliary (3 bytes deep)");
	case 0x18: return QString("DAC register");
	case 0x19: return QString("ADC register");

	case 0x1A: return QString("RX length");
	case 0x1B: return QString("RX length");
	case 0x1C: return QString("FIFO status");
	case 0x1D: return QString("TX length byte1");
	case 0x1E: return QString("TX length byte2");

	default:
		return "Unkown";
	}
}

int AS399X_Defines::regSize ( uchar addr )
{
	switch(addr)
	{
	case AS399X_ADDR_TESTSETTING:
	case AS399X_ADDR_CLSYSAOCPCTRL:
	case AS399X_ADDR_MODULATORCTRL:
	case AS399X_ADDR_PLLMAIN:
	case AS399X_ADDR_PLLAUX:
		return 3;
	default:
		return 1;
	}
}
